# EDDi

**E**ditor for **D**roid **D**o**i**ings

A visual coding language and IDE for Little Robot Friends.

## Dependencies:

EDDi requires the following:

1. [Python 2.x](https://www.python.org/downloads/)
2. [Yotta (follow manual install for Windows)](http://docs.yottabuild.org/#installing-on-windows)
3. [SRecord 1.64](https://sourceforge.net/projects/srecord/files/srecord-win32/1.64/) and move it to ``` C:\```
4. [Visual Studio and/or the C++ toolchains](https://www.visualstudio.com/downloads/)
5. The [LRF in-house MakeCode platform](https://github.com/littlerobotfriends/lrf_pxt)

Also, make sure you add these to your Path:
```
C:\Python27\Scripts
C:\srecord_dir
```

Also also, make sure you have npm __version 4.6.1__ and node installed and the Typings and Jake packages:
```
npm install -g npm@4.6.1
npm install -g typings
npm install -g jake
```

## Installation:

### 3rd Party tools
Install the first three items in the [dependencies](#dependencies) list using their individual instructions

### MakeCode
Clone [our version of the MakeCode platform](https://github.com/littlerobotfriends/lrf_pxt) next to EDDi

```
git clone https://github.com/littlerobotfriends/lrf_pxt
cd lrf_pxt
```

Install node modules, typings, and build
```
npm install
typings install
jake
```

Install pxt globally
```
npm install -g pxt
```

### Linking MakeCode and EDDi
Switch to the EDDi directory and install node modules:
```
cd ../LRF_EDDi
npm install
```
Then link pxt:
```
npm link ../lrf_pxt
```

## Running

To run the app use lrf_pxt's build in electron tools:

First, build the npm modules in the lrf_pxt/electron directory (you only have to do this once)

```
cd path_to_lrf_pxt/electron
npm install
```

Then, go back to the LRF_EDDi target and run:

```
pxt electron init    <------- only needed once
pxt electron run
```
